//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner),
        kolorTla((TColor)RGB(0,0,25))
{
}
//---------------------------------------------------------------------------

bool TForm1::GL_UstalFormatPikseli(HDC uchwytDC)
{
   PIXELFORMATDESCRIPTOR opisFormatuPikseli;
   ZeroMemory(&opisFormatuPikseli,sizeof(opisFormatuPikseli));
   opisFormatuPikseli.nVersion=1;
   opisFormatuPikseli.dwFlags=PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW |
   PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie
   opisFormatuPikseli.iPixelType=PFD_TYPE_RGBA; //typ koloru RGB
   opisFormatuPikseli.cColorBits=32; //jakosc kolorw 4 bajty
   opisFormatuPikseli.cDepthBits=16; //glebokosc bufora Z (z-buffer)
   opisFormatuPikseli.iLayerType=PFD_MAIN_PLANE;

   int formatPikseli=ChoosePixelFormat(uchwytDC,&opisFormatuPikseli);
   if (formatPikseli==0) return false;
   if (SetPixelFormat(uchwytDC,formatPikseli,&opisFormatuPikseli)!=true) return
   false;
   return true;
}

void TForm1::GL_UstawienieSceny()
{
   glViewport(0,0,ClientWidth,ClientHeight); //okno OpenGL = wnetrze formy (domyslnie)

   //ustawienie punktu projekcji
   glMatrixMode(GL_PROJECTION); //przeczenie na macierz projekcji
   glLoadIdentity();
   //left,right,bottom,top,znear,zfar (clipping)
   float wsp=ClientHeight/(float)ClientWidth;
   glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 25.0);
   //mnozenie macierzy rzutowania przez macierz perspektywy - ustalanie frustum
   glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu
   glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych powierzchni
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   //biezace okno staje sie oknem OpenGL
   uchwytDC=GetDC(Handle);
   if (!GL_UstalFormatPikseli(uchwytDC)) ShowMessage("Nie udao si ustali formatu pikseli");
   uchwytRC=wglCreateContext(uchwytDC);
   if (uchwytRC==NULL) ShowMessage("Nie udao si pobra uchwytu kontekstu grafiki");
   if (!wglMakeCurrent(uchwytDC,uchwytRC)) ShowMessage("Inicjacja grafiki OpenGL nie powioda si");
   GL_UstawienieSceny();
   Caption=(AnsiString)"OpenGL "+(char*)glGetString(GL_VERSION);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   wglMakeCurrent(NULL,NULL);
   wglDeleteContext(uchwytRC);
   ReleaseDC(Handle,uchwytDC);
   PostQuitMessage(0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   const float x0=1.0;
   const float y0=1.0;
   const float z0=1.0;

   //Przygotowanie bufora
   //glClearColor(1.0,1.0,1.0,0.0); //biale tlo
   glClearColor(0.0,0.0,0.1,0.0); //ciemnogranatowe tlo
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czysci bufory
   glLoadIdentity(); //macierz model-widok = macierz jednostkowa
   glTranslatef(0.0, 0.0, -10.0); //odsuniecie calosci o 10

   //rysowanie ostroslupa
   RysujOstroslup(x0,y0,z0);

   //Z bufora na ekran
   glFlush();
   SwapBuffers(uchwytDC);
}

void __fastcall TForm1::FormPaint(TObject *Sender)
{
   RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RysujOstroslup(float x0,float y0,float z0)
{
   //Rysowanie trojkata
   glBegin(GL_TRIANGLES);
   //ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
   //(0,0,z) jest mniej wiecej w srodku ekranu

   //tylna
   glColor3ub(255,255,0); //zolty
   glVertex3f(-x0, -y0, z0); //dolny lewy
   //glColor3ub(255,0,255); //fuksja
   glVertex3f(x0, -y0, z0); //dolny prawy
   //glColor3ub(0,255,255); //blekit
   glVertex3f(0, y0, z0); //gorny

   //podstawa
   glColor3ub(0,255,0); //zielony
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni

   //lewa
   glColor3ub(255,0,0); //czerwony
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(0, -y0, 2*z0); //dolny przedni
   glVertex3f(0, y0, z0); //gorny

   //prawa
   glColor3ub(0,0,255); //niebieski
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni
   glVertex3f(0, y0, z0); //gorny

   //koniec rysowania figury
   glEnd();
}


